﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Audio;
using UnityEngine.UI;

public class SettingMenu : MonoBehaviour {

	public AudioMixer auidoMixer;
	public Dropdown resoultionDropdown;
	Resolution[] resolutions;

	void Start()
	{
		resolutions = Screen.resolutions;

		resoultionDropdown.ClearOptions ();


		List<string> options = new List<string> ();

		int currentresolutionindex = 0;
		for(int i =0; i<resolutions.Length; i++)
		{
			string option = "width" + "x" + resolutions [i].height;
			options.Add (option);

			if(resolutions[i].width == Screen.currentResolution.width && 
				resolutions[i].height == Screen.currentResolution.height)
			{
				currentresolutionindex = i;
			}
		}

		resoultionDropdown.AddOptions (options);
		resoultionDropdown.value = currentresolutionindex;
		resoultionDropdown.RefreshShownValue ();
	}

	public void SetResolution(int resolutionIndex)
	{
		Resolution resoltion = resolutions [resolutionIndex];
		Screen.SetResolution (resoltion.width, resoltion.height, Screen.fullScreen);
	}

	public void SetVolume (float volume)
	{
		auidoMixer.SetFloat ("volume", volume);
	}

	public void SetQuality(int qualityindex)
	{
		QualitySettings.SetQualityLevel (qualityindex);
	}

	public void SetFullScreen(bool isFullscreen)
	{
		Screen.fullScreen = isFullscreen;
	}
}
